/*
 * Decompiled with CFR 0.152.
 */
package com.immensedb.jdbc;

import com.immensedb.common.Message;
import com.immensedb.jdbc.ImmenseDbConnection;
import com.immensedb.jdbc.ImmenseDbResultSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;

public class ImmenseDbPreparedStatement
implements PreparedStatement {
    ImmenseDbConnection connection;
    String sql;
    ImmenseDbResultSet dnUnSQLResultSet;
    boolean resultSetCalled = false;
    int updateRowCount = -1;
    HashMap<Integer, Object> valMap = new HashMap();

    public ImmenseDbPreparedStatement(ImmenseDbConnection connection, String sql) {
        this.connection = connection;
        this.sql = sql;
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public boolean execute() throws SQLException {
        String result;
        String qString = new String(this.sql);
        int pos = 0;
        while (qString.indexOf(":?") != -1) {
            if (++pos > this.valMap.size()) {
                throw new SQLException("No value found for index " + pos);
            }
            qString = String.valueOf(qString.substring(0, qString.indexOf(":?") + 1)) + this.valMap.get(pos) + qString.substring(qString.indexOf(":?") + 2);
        }
        this.connection.sendMessage(qString);
        try {
            result = this.connection.getMessage();
        }
        catch (IOException e) {
            throw new SQLException("Connection error.Disconnect.");
        }
        if (result instanceof String && Message.INVALID_STATEMENT.equals(result)) {
            throw new SQLException(Message.INVALID_STATEMENT);
        }
        if (result instanceof String && result.startsWith(Message.FAILED_STATUS)) {
            throw new SQLException(result);
        }
        if (result instanceof String && result.startsWith(Message.ERROR_STATUS)) {
            throw new SQLException(result);
        }
        if (result instanceof Object[]) {
            this.dnUnSQLResultSet = new ImmenseDbResultSet(this.connection, (Object[])result);
            this.updateRowCount = -1;
        }
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        String result;
        String qString = new String(this.sql);
        int pos = 0;
        while (qString.indexOf(":?") != -1) {
            if (++pos > this.valMap.size()) {
                throw new SQLException("No value found for index " + pos);
            }
            qString = String.valueOf(qString.substring(0, qString.indexOf(":?") + 1)) + this.valMap.get(pos) + qString.substring(qString.indexOf(":?") + 2);
        }
        try {
            this.connection.sendMessage(qString);
            result = this.connection.getMessage();
        }
        catch (IOException io) {
            throw new SQLException("Connection error.Disconnect.");
        }
        if (result instanceof String && Message.INVALID_STATEMENT.equals(result)) {
            throw new SQLException(Message.INVALID_STATEMENT);
        }
        if (result instanceof String && result.startsWith(Message.FAILED_STATUS)) {
            throw new SQLException(result);
        }
        if (result instanceof String && result.startsWith(Message.ERROR_STATUS)) {
            throw new SQLException(result);
        }
        if (!(result instanceof String)) {
            this.updateRowCount = -1;
            return null;
        }
        Object[] arrayR = result.split("\n");
        this.dnUnSQLResultSet = new ImmenseDbResultSet(this.connection, arrayR);
        this.updateRowCount = -1;
        this.resultSetCalled = true;
        return this.dnUnSQLResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        String result;
        this.connection.sendMessage(this.sql);
        try {
            result = this.connection.getMessage();
        }
        catch (IOException io) {
            throw new SQLException("Connection error.Disconnect.");
        }
        if (result instanceof String && Message.INVALID_STATEMENT.equals(result)) {
            throw new SQLException(Message.INVALID_STATEMENT);
        }
        if (result instanceof String && result.startsWith(Message.FAILED_STATUS)) {
            throw new SQLException(result);
        }
        if (result instanceof String && result.startsWith(Message.ERROR_STATUS)) {
            throw new SQLException(result);
        }
        return 1;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.valMap.put(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.valMap.put(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.valMap.put(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.valMap.put(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.valMap.put(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return null;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.resultSetCalled = true;
        return this.dnUnSQLResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateRowCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    public String toString() {
        String qString = new String(this.sql);
        int pos = 0;
        while (qString.indexOf(":?") != -1) {
            if (++pos > this.valMap.size()) {
                return "No value found for index " + pos;
            }
            qString = String.valueOf(qString.substring(0, qString.indexOf(":?") + 1)) + this.valMap.get(pos) + qString.substring(qString.indexOf(":?") + 2);
        }
        return qString;
    }
}

