/*
 * Decompiled with CFR 0.152.
 */
package com.immensedb.jdbc;

import com.immensedb.common.Message;
import com.immensedb.jdbc.ImmenseDbDatabaseMetaData;
import com.immensedb.jdbc.ImmenseDbPreparedStatement;
import com.immensedb.jdbc.ImmenseDbStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ImmenseDbConnection
implements Connection {
    PrintWriter out;
    BufferedReader in;
    String message;
    Socket sock;
    static String STARTING_URL = "jdbc:immensedb://";
    DatabaseMetaData databaseMetaData;
    String host;
    String database;
    String user;
    String password;
    String port;

    ImmenseDbConnection(String url, Properties arg1) throws SQLException {
        try {
            if (!url.substring(0, STARTING_URL.length()).equals(STARTING_URL)) {
                throw new SQLException("Invalid Staring of url");
            }
            if (url.substring(STARTING_URL.length()).indexOf("/") == -1) {
                throw new SQLException("Invalid Staring of url");
            }
            this.database = url.substring(STARTING_URL.length());
            this.host = this.database.substring(0, this.database.indexOf("/"));
            this.user = arg1.getProperty("user");
            this.password = arg1.getProperty("password");
            if (this.host.indexOf(":") != -1) {
                this.port = this.host.substring(this.host.indexOf(":") + 1);
                this.host = this.host.substring(0, this.host.indexOf(":"));
            } else {
                this.port = Message.DEFAULT_PORT;
            }
            this.database = this.database.substring(this.database.indexOf("/") + 1);
            this.sock = new Socket(this.host, (int)new Integer(this.port));
            this.out = new PrintWriter(this.sock.getOutputStream(), true);
            this.out.flush();
            this.in = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            this.sendMessage("connect " + this.user + " " + this.password);
            char[] chr = new char[10240];
            int i = this.in.read(chr, 0, chr.length);
            this.message = new String(chr);
            if (this.message.startsWith(Message.INVALID_USER)) {
                this.close();
                throw new SQLException("Unable to authenticate. Invalid user details");
            }
            this.sendMessage("use " + this.database);
            chr = new char[10240];
            this.message = this.getMessage();
            if (this.message.startsWith(Message.INVALID_DB)) {
                this.close();
                throw new SQLException(String.valueOf(this.database) + " Database Not found");
            }
            this.sendMessage("getDbProperties");
            i = this.in.read(chr, 0, chr.length);
            this.message = new String(chr);
            if (i != -1) {
                this.message = this.message.substring(0, i);
            }
            this.databaseMetaData = new ImmenseDbDatabaseMetaData(this, this.message, url, this.user);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    void sendMessage(String msg) {
        this.out.print(msg);
        this.out.flush();
        msg = null;
    }

    String getMessage() throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] chr = new char[10240];
        int i = this.in.read(chr, 0, chr.length);
        String message = new String(chr);
        while (i != -1) {
            message = message.substring(0, i);
            sb.append(message);
            if (i < 10240) break;
            i = this.in.read(chr, 0, chr.length);
            message = new String(chr);
        }
        return sb.toString();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ImmenseDbStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.database;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.databaseMetaData;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (this.sock != null) {
                return this.sock.isClosed();
            }
            return true;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        ImmenseDbPreparedStatement dnUnSQLPreparedStatement = new ImmenseDbPreparedStatement(this, sql);
        return dnUnSQLPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        ImmenseDbPreparedStatement dnUnSQLPreparedStatement = new ImmenseDbPreparedStatement(this, sql);
        return dnUnSQLPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        ImmenseDbPreparedStatement dnUnSQLPreparedStatement = new ImmenseDbPreparedStatement(this, sql);
        return dnUnSQLPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }
}

